

enum ResourceRequestCachePolicy
{
    UseProtocolCachePolicy, // normal load
    ReloadIgnoringCacheData, // reload
    ReturnCacheDataElseLoad, // back/forward or encoding change - allow stale data
    ReturnCacheDataDontLoad, // results of a post - allow stale data and only use cache
};

class ResourceRequest {

    ResourceRequest(const KURL&);
    ResourceRequest();
    ResourceRequest(const ResourceRequest&);

    const KURL& url() const;
    void setURL(const KURL&);

    ResourceRequestCachePolicy cachePolicy() const;
    void setCachePolicy(ResourceRequestCachePolicy);

    double timeoutInterval() const;
    void setTimeoutInterval(double);
    
    const KURL& mainDocumentURL() const;
    void setMainDocumentURL(const KURL&);

    const String& httpMethod() const;
    void setHTTPMethod(const String&);

    const String& httpHeaderField() const;
    void setHTTPHeaderField(const String& name, const String& value);
    void addHTTPHeaderField(const String& name, const String& value);

    const String httpContentType() const;
    void setHTTPContentType(const String&);

    const String& httpReferrer() const;
    void setHTTPReferrer(const String&);

    const String& httpUserAgent() const;
    void setHTTPUserAgent(const String&);

    const FormData& httpBody() const;
    FormData& httpBody();
    void setHTTPBody(const FormData&);

    bool allowHTTPCookies() const;
    void setAllowHTTPCookies(bool);
};

