

class ResourceLoaderClient : Shared<ResourceLoaderClient> {

    virtual ~ResourceLoaderClient();

    // request may be modified
    void willSendRequest(ResourceLoader*, Request&, const ResourceResonse& redirectResponse) = 0;
    
    void didReceiveAuthenticationChallenge(ResourceLoader*, const AuthenticationChallenge&) = 0;
    void didCancelAuthenticationChallenge(ResourceLoader*, const AuthenticationChallenge&) = 0;

    void didReceiveResponse(ResourceLoader*, const ResourceResponse&) = 0;
    void didReceiveData(ResourceLoader*, cont char*, long long) = 0;
    void didFinishLoading(ResourceLoader*) = 0;
    void didFailWithError(ResourceError*) = 0;

    // cached response may be modified
    void willCacheResponse(ResourceLoader*, CachedResourceResponse&) = 0;

};
