
class ResourceLoader : public Shared<ResourceLoader> {

 public:


    static bool canHandleRequest(const ResourceRequest&);

 private:
    
    ResourceLoader(ResourceRequest&, PassRefPtr<ResourceLoaderClient>);

 public:
    static PassRefPtr<ResourceLoader> create(ResourceRequest&, PassRefPtr<ResourceLoaderClient>);

    static sendSynchronousRequest(ResourceRequest&, ResourceResponse& responseResult, ResourceError& errorResult, Vector<char>& dataResult);

    void cancel();
    
    bool defersCallbacks() const;
    void setDefersCallbacks(bool);

};

